//
//  APTracker.m
//  APlayer
//
//  Created by Holger Sadewasser on 4/19/08.
//  Copyright 2008. All rights reserved.
//

#import "APTracker.h"
#import "APObject.h"
#import "parameter.h"
#import "tools.h"
#ifdef WITH_WINDOW
#import "APView.h"
extern APView *gView;
#endif


// methods that are used internally by this class, but should not be needed externally
// are defined here to keep them "private". Anyone who knows about them can still call
// them of course, but by putting the prototypes here, it emphasizes that they are only
// meant for internal use.
@interface APTracker(_private_methods)

-(APObject *)_identifyObjectWithType:(int)iType size:(int)iSize posX:(int)iPosX posY:(int)iPosY frames:(uint8_t)iFrames ping:(uint8_t)iPing;

@end


@implementation APTracker

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

-(id)initWithIOChannel:(APIOChannel *)iIOChannel {
  self = [super init];
  if (self != nil) {
    mIOChannel = iIOChannel;
    [mIOChannel retain];
//    [mIOChannel setDataCallbackObject:self];
    [mIOChannel setWriteCallbackObject:self];
    
    mFrameNo = 0;
    
    mFrames = [[NSMutableData alloc] init];
    mFlgRecordFrames = NO;
    mRecordedFrames = 0;
    
    mLastPing = 0;
    bzero(mKeys,sizeof(mKeys));
    
    mShip = [[APShip alloc] initWithKeysBuffer:mKeys];
    mSaucer = [[APSaucer alloc] init];    
    mFlgShipInitialized = YES;
    mFlgSaucerInitialized = YES;
  }
  return self;
}


-(void)dealloc {
  [mObjects release];
  [mSaucer release];
  [mShip release];
  [mFrames release];
//  [mIOChannel setDataCallbackObject:nil];
  [mIOChannel setWriteCallbackObject:nil];
  [mIOChannel release];
  [super dealloc];
}


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(void)didSendKeys:(uint8_t)iKeys ping:(uint8_t)iPing {
 
  uint8_t count = (uint8_t)(iPing - mLastPing);
  
  while ( count > 1 ) {
    mKeys[++mLastPing] = 0;
    --count;
  }
  
  mLastPing = iPing;
  mKeys[mLastPing] = iKeys;
  
//  NSLog(@"did send %#x at ping %d", (int)iKeys, (int)iPing);
}


-(NSArray *)interpretScreen:(NSData *)iPacket {
  
	unsigned short *vector_ram = (unsigned short *)[iPacket bytes];
  unsigned short vr, vr1;
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;
  NSMutableArray *newObjects = [[NSMutableArray alloc] init];
  BOOL flgDone = NO;
  
  uint8_t frameno = ((uint8_t *)vector_ram)[1024];
  uint8_t frames = frameno - mFrameNo;
  uint8_t ping = ((uint8_t *)vector_ram)[1025];
  
  int numAsteroids = 0;
  int numShots = 0;
  int flgShipPresent = NO;
  int flgSaucerPresent = NO;
  
  
	if (((unsigned char *)vector_ram)[1] != 0xe0 && ((unsigned char *)vector_ram)[1] != 0xe2)
		return mObjects; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL
  
	int pc = 1;
	while ( flgDone == NO && pc < 512 )
	{
    vr  = EndianU16_LtoN(vector_ram[pc]);
    vr1 = EndianU16_LtoN(vector_ram[pc+1]);
    
		int op = vr >> 12;
		switch (op)
		{
      case 0xa: // LABS
        vy = vr & 0x3ff;
        vx = vr1 & 0x3ff;
        vs = vr1 >> 12;
        break;
      case 0xb: // HALT
        flgDone = YES;
        break;
      case 0xc: // JSRL
        switch (vr & 0xfff)
        {
          case 0x8f3:
            [newObjects addObject:[self _identifyObjectWithType:cAsteroid1 size:vs posX:vx posY:vy frames:frames ping:ping]];
            ++numAsteroids;
            break;
          case 0x8ff:
            [newObjects addObject:[self _identifyObjectWithType:cAsteroid2 size:vs posX:vx posY:vy frames:frames ping:ping]];
            ++numAsteroids;
            break;
          case 0x90d:
            [newObjects addObject:[self _identifyObjectWithType:cAsteroid3 size:vs posX:vx posY:vy frames:frames ping:ping]];
            ++numAsteroids;
            break;
          case 0x91a:
            [newObjects addObject:[self _identifyObjectWithType:cAsteroid4 size:vs posX:vx posY:vy frames:frames ping:ping]];
            ++numAsteroids;
            break;
          case 0x929:
            if ( mFlgSaucerPresent == NO )
              [mSaucer setSize:vs posX:vx posY:vy];
            else
              [mSaucer updateWithPosX:vx posY:vy frames:frames];
            [newObjects addObject:mSaucer];
            flgSaucerPresent = YES;
            mFlgSaucerInitialized = NO;
            break;
        }  
        break;
      case 0xd: // RTSL
        flgDone = YES;
        break;
      case 0xe: // JMPL
        /*
         pc = vr & 0xfff;
         break;
         */
        flgDone = YES;
        break;
      case 0xf: // SVEC
        /*
         dy = vr & 0x300;
         if ((vr & 0x400) != 0)
         dy = -dy;
         dx = (vr & 3) << 8;
         if ((vr & 4) != 0)
         dx = -dx;
         sf = (((vr & 8) >> 2) | ((vr & 0x800) >> 11)) + 2;
         vz = (vr & 0xf0) >> 4;
         */
        break;
      default:
        dy = vr & 0x3ff;
        if ( (vr & 0x400) != 0 )
          dy = -dy;
        dx = (vr1 & 0x3ff);
        if ((vr1 & 0x400) != 0)
          dx = -dx;
        sf = op;
        vz = vr1 >> 12;
        if (dx == 0 && dy == 0 && vz == 15) {
          [newObjects addObject:[self _identifyObjectWithType:cShot size:0 posX:vx posY:vy frames:frames ping:ping]];
          ++numShots;
        } else if (dx == 0 && dy == 0 && vz != 0 ) {
          NSLog(@"shot with vz = %d", (int)vz);
        }
        if (op == 6 && vz == 12 && dx != 0 && dy != 0)
        {
            switch (shipdetect)
          {
            case 0:
              v1x = dx;
              v1y = dy;
              ++shipdetect;
              break;
            case 1:
              if ( mFlgShipPresent == NO )
                [mShip setPosX:vx posY:vy viewX:(v1x-dx) viewY:(v1y-dy)];
              else
                [mShip updateWithPosX:vx posY:vy viewX:(v1x-dx) viewY:(v1y-dy) frame:frameno frames:frames ping:ping lastPing:mLastPing];
//              NSLog(@"Ship view %d %d at ping: %d\n", (v1x-dx), (v1y-dy), (int)ping);
              [newObjects addObject:mShip];
              flgShipPresent = YES;
              mFlgShipInitialized = NO;
              ++shipdetect;
              break;
          }
        }
          else if (shipdetect == 1)
            shipdetect = 0;
          
          break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   
  
//- Begin Records shot angles ---------------------
//  unsigned int count = [newObjects count];
//  unsigned int index;
//  APObject * object;
//  for ( index = 0; index < count; index++ ) {
//    
//    object = [newObjects objectAtIndex:index];
//    
//    if ( object->mType == cShot ) {
////      NSLog(@"tf: %d", object->mTotalFrames);
//      if ( object->mTotalFrames == 1 ) {
////        NSLog(@"ox: %lf\toy: %lf\tsx: %lf\tsy: %lf", object->mInitPosX, object->mInitPosY, mShip->mPosX, mShip->mPosY);
//        double dx = object->mInitPosX - mShip->mPosX;
//        double dy = object->mInitPosY - mShip->mPosY;
////        NSLog(@"dx: %lf\tdy: %lf\tdist: %lf\tvx: %lf\tvy: %lf", dx, dy, dx*dx + dy*dy, mShip->mViewX, mShip->mViewY);
//        if ( dx*dx + dy*dy < 485.0 ) {
//          object->mShipViewX = mShip->mViewX;
//          object->mShipViewY = mShip->mViewY;
//          object->mPing = ping;
//          object->mAngleByteTmp = mAngleByte;
//          object->mFlgRecording = YES;
//          ++numShots;
//        }
//      } else if ( object->mShipViewX != 0.0 || object->mShipViewY != 0.0 ) {
//        ++numShots;
//      }
//    }
//  }
//- End Records shot angles ---------------------
  
  if ( mFlgRecordFrames == YES && mRecordedFrames <= 100 ) {
    int i;
    for ( i = pc+1; i < 512; i++ ) {
      vector_ram[i] = 0;
    }
    ((unsigned char *)vector_ram)[1] = 0xe0;
    [mFrames appendBytes:vector_ram length:1024];
    mRecordedFrames++;
    if ( mRecordedFrames == 100 ) {
      [mFrames writeToFile:@"/Users/holger/MAME/frames.dat" atomically:NO];
      mFlgRecordFrames = NO;
    }
  }
  
  mNumAsteroids = numAsteroids;
  mNumShots = numShots;
  mFlgShipPresent = flgShipPresent;
  mFlgSaucerPresent = flgSaucerPresent;  
  mFrameNo = frameno;
  if ( mFlgSaucerPresent == NO && mFlgSaucerInitialized == NO ) {
    [mSaucer init];
    mFlgSaucerInitialized = YES;
  }
  if ( mFlgShipPresent == NO && mFlgShipInitialized == NO ) {
    [mShip init];
    mFlgShipInitialized = YES;
  }
  
  //  NSLog(@"asteroids: %d\n", mNumAsteroids);
  //  NSLog(@"shots: %d\n", mNumShots);
  //  NSLog(@"ship: %d\n", flgShipPresent);
  //  NSLog(@"saucer: %d\n", flgSaucerPresent);

//  int index;
//  APObject * object;
//  int count = [mObjects count];
//  for ( index = 0; index < count; index++ ) {
//    object = [mObjects objectAtIndex:index];
//    NSLog(@"retain count: %u  total frames: %u", [object retainCount], object->mTotalFrames);
//  }
  [mObjects release];
  mObjects = newObjects;
  
#ifdef WITH_WINDOW
  [gView setObjects:mObjects];
  [gView setNeedsDisplay:YES];
#endif
  
  return mObjects;
}


-(uint8_t)lastPing {
  return mLastPing;
}


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Private Methods
// -------------------------------------------------------------------------------------

-(APObject *)_identifyObjectWithType:(int)iType size:(int)iSize posX:(int)iPosX posY:(int)iPosY frames:(uint8_t)iFrames ping:(uint8_t)iPing {
  
  unsigned int index;
  unsigned int count = [mObjects count];
  APObject * object;

  double dist;
  
  double singleFrameDist = 1e10;
  double singleFrameIndex = -1;
  APObject * singleFrameObject = nil;

//  double multiFrameDist = 1e10;
  double multiFrameDiv = 1e10;
  double multiFrameIndex = -1;
  APObject * multiFrameObject = nil;
  
  for ( index = 0; index < count; index++ ) {
    
    object = [mObjects objectAtIndex:index];
    
    if ( [object matchesObjectWithType:iType size:iSize posX:iPosX posY:iPosY atDistance:&dist] ) {
      if ( [object frames] == 1 ) {
        if ( dist < singleFrameDist ) {
          singleFrameDist = dist;
          singleFrameObject = object;
          singleFrameIndex = index;
        }
      } else {
        if ( dist < multiFrameDiv ) {
          multiFrameDiv = dist;
          multiFrameObject = object;
          multiFrameIndex = index;
        }
      }
    }
  }
  
  if ( multiFrameObject != nil ) {
    object = multiFrameObject;
    index = multiFrameIndex;
    //    NSLog(@"Object identified 2 type: %d size: %d x: %lf -> %d y: %lf -> %d dist: %lf hx: %lf hy: %lf div: %lf f: %d\n",
    //          iType, iSize, object->mPosX, iPosX, object->mPosY, iPosY, multiFrameDist, object->mHeadingX, object->mHeadingY, multiFrameDiv, object->mTotalFrames);
  } else if ( singleFrameObject != nil ) {
    object = singleFrameObject;
    index = singleFrameIndex;
    //    NSLog(@"Object identified 1 type: %d size: %d x: %lf -> %d y: %lf -> %d dist: %lf hx: %lf hy: %lf f: %d\n",
    //          iType, iSize, object->mPosX, iPosX, object->mPosY, iPosY, singleFrameDist, object->mHeadingX, object->mHeadingY, object->mTotalFrames);
  } else {
    object = nil;
  }
  
  if ( object != nil ) {
    [object retain];
    [mObjects removeObjectAtIndex:index];
    [object updateWithPosX:iPosX posY:iPosY frames:iFrames];
    
    //    NSLog(@"Object type: %d size: %d x: %lf y: %lf hx: %lf hy: %lf f: %d\n",
    //          object->mType, object->mSize, object->mPosX, object->mPosY, object->mHeadingX, object->mHeadingY, object->mTotalFrames);

    return [object autorelease];
  } else {
    if ( iType != cShot )
      NSLog(@"New object type: %d size: %d x: %d y: %d\n", iType, iSize, iPosX, iPosY);
//    if ( iType == cShot ) NSLog(@"Angle byte: %d  new shot at x: %d  y: %d  ping: %d\n", (int)(mShip->mAngleByte), iPosX, iPosY, (int)iPing);
    return [[[APObject alloc] initWithType:iType size:iSize posX:iPosX posY:iPosY] autorelease];
  }
}


@end
